let user_signed_in = false
let neededHead = ['access-token', 'client', 'expiry', 'uid', 'token-type']
let sendHeader = {'content-type': 'application/json'}
const base_url = "https://shortname.it"

chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    // Use switch
    switch (request.message) {
        case 'login':
            url = base_url + '/api/users/sign_in'
            fetch(url,{
            method: "POST",
            mode: 'cors',
            headers: sendHeader,
            body: JSON.stringify(request.payload)
            })
            .then(function(res){
                if(res.status !== 200){
                    sendResponse('fail')
                    return;
                }
                res.json().then(function(data){
                    sendResponse('success')
                    for(let head of neededHead){
                        sendHeader[head] = res.headers.get(head)
                    }
                    chrome.storage.local.set({user_signed_in: true, token: sendHeader});
                    user_signed_in = true
                })
            })
            return true;
            break;
        case 'logout':
            user_signed_in = false
            sendHeader = {'content-type': 'application/json'}
            chrome.storage.local.set({user_signed_in: false, token: {}});
            sendResponse('loggedout')
            break;
        case 'checkuser':
            chrome.storage.local.get(['user_signed_in', 'token'], function(res) {
                if(res['user_signed_in'] == true){
                    sendResponse('hasuser')
                    user_signed_in = true
                    sendHeader = res['token']
                }else{
                    sendResponse('nouser')
                }
            });
            return true;
            break;
        case 'loaddomains':
            url = base_url + '/api/v1/domains'
            fetch(url,{
            headers: sendHeader,
            })
            .then(function(res){
                if(res.status !== 200){
                    sendResponse('fail')
                    return;
                }
                res.json().then(function(data){
                    sendResponse({message: 'success', body: data.data})
                })
            })
            return true;
            break;
        case 'loadbookmarks':
            url = base_url+'/api/v1/domains/'+ request.payload +'/bookmarks'
            fetch(url,{
                method: 'GET',
                headers: sendHeader,
            })
            .then(function(res){
                if(res.status !== 200){
                    sendResponse('fail')
                    return;
                }
                res.json().then(function(data){
                    sendResponse({message: 'success', body: data.data})
                })
            })
            return true;
            break;
        case 'createbookmark':
            url = base_url + '/api/v1/domains/'+ request.dom_id +'/bookmarks'
            fetch(url,{
                method: 'POST',
                headers: sendHeader,
                mode: 'cors',
                body: JSON.stringify({"bookmarks": [request.payload]})
            })
            .then(function(res){
                if(res.status !== 200){
                    res.json().then(function(data){
                        sendResponse({status: 'fail', errors: data.error.split(',')} )
                        return;
                    })
                    return
                }
                res.json().then(function(data){
                    sendResponse({status: 'success'})
                })
            })
            return true;
        default:
            break;
    }
});